//------------------------------------------------------------------

   #property copyright "mladen"
   #property link      "www.forex-tsd.com"
   
//------------------------------------------------------------------

#property indicator_separate_window
#property indicator_buffers  6
#property indicator_color1   DeepSkyBlue
#property indicator_color2   DeepSkyBlue
#property indicator_color3   PaleVioletRed
#property indicator_color4   PaleVioletRed
#property indicator_color5   Silver
#property indicator_color6   Gold
#property indicator_width1   2
#property indicator_width3   2
#property indicator_width5   2
#property indicator_width6   2

//
//
//
//
//

extern string TimeFrame      = "Current time frame";
extern int    ROCPeriod1     = 14;
extern int    ROCPeriod2     = 11;
extern int    Smooth         = 10;
extern int    Signal         =  5;
extern int    SignalMethod   = MODE_SMA;
extern bool   ShowHistogram  = true;

//
//
//
//
//

double osc[];
double histUu[];
double histUd[];
double histDd[];
double histDu[];
double signal[];
double slope[];

string indicatorFileName;
bool   returnBars;
bool   calculateValue;
int    timeFrame;

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//

int init()
{
   int style = DRAW_NONE; if (ShowHistogram) style = DRAW_HISTOGRAM;
      IndicatorBuffers(7);
      SetIndexBuffer(0,histUu); SetIndexStyle(0,style);
      SetIndexBuffer(1,histUd); SetIndexStyle(1,style);
      SetIndexBuffer(2,histDd); SetIndexStyle(2,style);
      SetIndexBuffer(3,histDu); SetIndexStyle(3,style);
      SetIndexBuffer(4,osc);    SetIndexLabel(4,"Coppock curve");
      SetIndexBuffer(5,signal); SetIndexLabel(5,"Coppock curve signal");
      SetIndexBuffer(6,slope);

      //
      //
      //
      //
      //

      indicatorFileName = WindowExpertName();
      calculateValue    = TimeFrame=="calculateValue"; if (calculateValue) { return(0); }
      returnBars        = TimeFrame=="returnBars";     if (returnBars)     { return(0); }
      timeFrame         = stringToTimeFrame(TimeFrame);
   IndicatorShortName(timeFrameToString(timeFrame)+" Coppock curve "+" ("+ROCPeriod1+","+ROCPeriod2+","+Smooth+","+Signal+")");
   return(0);
}
int deinit() { return(0); }


//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

int start()
{
   int counted_bars=IndicatorCounted();
      if(counted_bars<0) return(-1);
      if(counted_bars>0) counted_bars--;
           int limit=MathMin(Bars-counted_bars,Bars-1);
           if (returnBars) { histUu[0] = MathMin(limit+1,Bars-1); return(0); }

   //
   //
   //
   //
   //

   if (calculateValue || timeFrame == Period())
   {
      for (int i=limit;i>=0;i--)
      {
         osc[i]    = iLwma(iROC(ROCPeriod1,i)+iROC(ROCPeriod2,i),Smooth,i,0);
         histUu[i] = EMPTY_VALUE;
         histUd[i] = EMPTY_VALUE;
         histDd[i] = EMPTY_VALUE;
         histDu[i] = EMPTY_VALUE;
         slope[i]  = slope[i+1];

            if (osc[i] > osc[i+1]) slope[i] =  1;
            if (osc[i] < osc[i+1]) slope[i] = -1;
            if (osc[i] > 0 && slope[i] ==  1) histUu[i] = osc[i];
            if (osc[i] > 0 && slope[i] == -1) histUd[i] = osc[i];
            if (osc[i] < 0 && slope[i] ==  1) histDu[i] = osc[i];
            if (osc[i] < 0 && slope[i] == -1) histDd[i] = osc[i];
      }
      if (Signal>1) for (i=limit; i>=0; i--) signal[i] = iMAOnArray(osc,0,Signal,0,SignalMethod,i);
      return(0);
   }      

   //
   //
   //
   //
   //
      
   limit = MathMax(limit,MathMin(Bars-1,iCustom(NULL,timeFrame,indicatorFileName,"returnBars",0,0)*timeFrame/Period()));
   for (i=limit; i>=0; i--)
   {
      int y = iBarShift(NULL,timeFrame,Time[i]);
         histUu[i] = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",ROCPeriod1,ROCPeriod2,Smooth,Signal,SignalMethod,0,y);
         histUd[i] = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",ROCPeriod1,ROCPeriod2,Smooth,Signal,SignalMethod,1,y);
         histDd[i] = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",ROCPeriod1,ROCPeriod2,Smooth,Signal,SignalMethod,2,y);
         histDu[i] = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",ROCPeriod1,ROCPeriod2,Smooth,Signal,SignalMethod,3,y);
         osc[i]    = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",ROCPeriod1,ROCPeriod2,Smooth,Signal,SignalMethod,4,y);
         signal[i] = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",ROCPeriod1,ROCPeriod2,Smooth,Signal,SignalMethod,5,y);
   }
   return(0);         
}
 

//------------------------------------------------------------------
//
//------------------------------------------------------------------
//
//
//
//
//

double workLwma[][1];
double iLwma(double price, double period, int r, int instanceNo=0)
{
   if (ArraySize(workLwma)!= Bars) ArrayResize(workLwma,Bars); r = Bars-r-1;
   
   //
   //
   //
   //
   //
   
   workLwma[r][instanceNo] = price;
      double sumw = period;
      double sum  = period*price;

      for(int k=1; k<period && (r-k)>=0; k++)
      {
         double weight = period-k;
                sumw  += weight;
                sum   += weight*workLwma[r-k][instanceNo];  
      }             
      return(sum/sumw);
}

//
//
//
//
//

double iROC(int period, int shift)
{
   double ROC;

   if (Close[shift + period] != 0)
          ROC = (Close[shift]-Close[shift + period]) / Close[shift + period];
   else   ROC = 0.00;
   return(ROC*100.00);
}

//+-------------------------------------------------------------------
//|                                                                  
//+-------------------------------------------------------------------
//
//
//
//
//

string sTfTable[] = {"M1","M5","M15","M30","H1","H4","D1","W1","MN"};
int    iTfTable[] = {1,5,15,30,60,240,1440,10080,43200};

//
//
//
//
//

int stringToTimeFrame(string tfs)
{
   tfs = stringUpperCase(tfs);
   for (int i=ArraySize(iTfTable)-1; i>=0; i--)
         if (tfs==sTfTable[i] || tfs==""+iTfTable[i]) return(MathMax(iTfTable[i],Period()));
                                                      return(Period());
}
string timeFrameToString(int tf)
{
   for (int i=ArraySize(iTfTable)-1; i>=0; i--) 
         if (tf==iTfTable[i]) return(sTfTable[i]);
                              return("");
}

//
//
//
//
//

string stringUpperCase(string str)
{
   string   s = str;

   for (int length=StringLen(str)-1; length>=0; length--)
   {
      int char = StringGetChar(s, length);
         if((char > 96 && char < 123) || (char > 223 && char < 256))
                     s = StringSetChar(s, length, char - 32);
         else if(char > -33 && char < 0)
                     s = StringSetChar(s, length, char + 224);
   }
   return(s);
}